% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmask.R
\name{getmask}
\alias{getmask}
\title{getmask}
\usage{
getmask(seq)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}
}
\value{
\code{IRanges} information from \code{metadata}
}
\description{
This function shows the mask slot from a
\code{DNAStringSet} or an \code{AAStringSet}
\code{metadata} information.\cr
}
\examples{
## load example sequence data
data(iupac, package="MSA2dist")
iupac.aa <- iupac |> cds2aa(shorten = TRUE)
## create mask
mask1 <- IRanges::IRanges(start=c(1,41), end=c(20,50))
## add mask
iupac.aa <- iupac.aa |> addmask2string(mask=mask1)
#(iupac.aa |> slot("metadata"))$mask
iupac.aa |> getmask()
}
\seealso{
\code{\link[MSA2dist]{addpop2string}}
}
\author{
Kristian K Ullrich
}
