% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnastring2codonmat.R
\name{dnastring2codonmat}
\alias{dnastring2codonmat}
\title{dnastring2codonmat}
\usage{
dnastring2codonmat(cds, shorten = FALSE, frame = 1, framelist = NULL)
}
\arguments{
\item{cds}{\code{DNAStringSet} [mandatory]}

\item{shorten}{shorten all sequences to multiple of three [default: FALSE]}

\item{frame}{indicates the first base of a the first codon [default: 1]}

\item{framelist}{supply vector of frames for each entry [default: NULL]}
}
\value{
An object of class \code{alignment} which is a list with the
following components:\cr
\code{nb} the number of aligned sequences\cr
\code{nam} a vector of strings containing the names of the aligned
sequences\cr
\code{seq} a vector of strings containing the aligned sequences\cr
\code{com} a vector of strings containing the commentaries for each sequence
or \code{NA} if there are no comments
}
\description{
This function converts a \code{DNAStringSet} into a
\code{codon matrix}.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATG---CATTGC")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
## convert into alignment
#dnastring2codonmat(cds1.cds2.aln)
cds1.cds2.aln |> dnastring2codonmat()
## use frame 2 and shorten to circumvent multiple of three error
cds1 <- Biostrings::DNAString("-ATGCAACATTGC-")
cds2 <- Biostrings::DNAString("-ATG---CATTGC-")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
cds1.cds2.aln |> dnastring2codonmat(frame=2, shorten=TRUE)
}
\seealso{
\code{\link[seqinr]{as.alignment}}
}
\author{
Kristian K Ullrich
}
