% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnastring2aln.R
\name{dnastring2aln}
\alias{dnastring2aln}
\title{dnastring2aln}
\usage{
dnastring2aln(dna)
}
\arguments{
\item{dna}{\code{DNAStringSet} [mandatory]}
}
\value{
An object of class \code{alignment} which is a list with the
following components:\cr
\code{nb} the number of aligned sequences\cr
\code{nam} a vector of strings containing the names of the aligned
sequences\cr
\code{seq} a vector of strings containing the aligned sequences\cr
\code{com} a vector of strings containing the commentaries for each sequence
or \code{NA} if there are no comments
}
\description{
This function converts a \code{DNAStringSet} into an
\code{seqinr} \code{alignment}.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATG---CATTGC")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
## convert into alignment
#dnastring2aln(cds1.cds2.aln)
cds1.cds2.aln |> dnastring2aln()
}
\seealso{
\code{\link[seqinr]{as.alignment}}
}
\author{
Kristian K Ullrich
}
