% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aln2aastring.R
\name{aln2aastring}
\alias{aln2aastring}
\title{aln2aastring}
\usage{
aln2aastring(aln)
}
\arguments{
\item{aln}{\code{seqinr} \code{alignment} [mandatory]}
}
\value{
An object of class \code{AAStringSet}
}
\description{
This function converts a \code{seqinr} \code{alignment} into
an \code{AAStringSet}.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATG---CATTGC")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
#aastring2aln(cds2aa(cds1.cds2.aln))
cds1.cds2.aln |> cds2aa() |> aastring2aln() |> aln2aastring()
}
\seealso{
\code{\link[seqinr]{as.alignment}}
\code{\link[Biostrings]{AAStringSet}}
}
\author{
Kristian K Ullrich
}
