% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addmask2string.R
\name{addmask2string}
\alias{addmask2string}
\title{addmask2string}
\usage{
addmask2string(seq, mask = NULL, append = TRUE)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}

\item{mask}{\code{IRanges} object [mandatory]}

\item{append}{indicate if mask should be appended or overwritten
[default: TRUE]}
}
\value{
An object of class \code{DNAStringSet} or \code{AAStringSet}
}
\description{
This function adds mask information as an \code{IRanges} object,
\code{START} and \code{END} information, to a
\code{DNAStringSet} or an \code{AAStringSet} and puts them into the
\code{metadata} information.
This information can be used to restrict the distance calculation to
specific regions of the \code{DNAStringSet} or the \code{AAStringSet}.
}
\examples{
## load example sequence data
data(iupac, package="MSA2dist")
iupac.aa <- iupac |> cds2aa(shorten = TRUE)
## create mask
mask1 <- IRanges::IRanges(start=c(1,41), end=c(20,50))
## add mask
iupac.aa <- iupac.aa |> addmask2string(mask=mask1)
#(iupac.aa |> slot("metadata"))$mask
iupac.aa |> getmask()
## append mask
mask2 <- IRanges::IRanges(start=c(21), end=c(30))
iupac.aa <- iupac.aa |> addmask2string(mask=mask2)
#(iupac.aa |> slot("metadata"))$mask
iupac.aa |> getmask()
## overwrite mask
iupac.aa <- iupac.aa |> addmask2string(mask=mask2, append=FALSE)
#(iupac.aa |> slot("metadata"))$mask
iupac.aa |> getmask()
## reduce by mask
#iupac.aa.region <- iupac.aa |> string2region(mask=
#    (iupac.aa |> slot("metadata"))$mask)
iupac.aa.region <- iupac.aa |> string2region(mask=
    getmask(iupac.aa))
#iupac.aa.region |> slot("metadata")
iupac.aa.region |> getmask()
}
\seealso{
\code{\link[MSA2dist]{addregion2string}},
\code{\link[MSA2dist]{addpop2string}},
\code{\link[MSA2dist]{addpos2string}}
}
\author{
Kristian K Ullrich
}
