% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aastring2dist.R
\name{aastring2dist}
\alias{aastring2dist}
\title{aastring2dist}
\usage{
aastring2dist(
  aa,
  threads = 1,
  symmetric = TRUE,
  score = NULL,
  mask = NULL,
  region = NULL
)
}
\arguments{
\item{aa}{\code{AAStringSet} [mandatory]}

\item{threads}{number of parallel threads [default: 1]}

\item{symmetric}{symmetric score matrix [default: TRUE]}

\item{score}{\code{score matrix} use a score matrix to calculate distances
[mandatory]}

\item{mask}{\code{IRanges} object indicating masked sites
[default: NULL]}

\item{region}{\code{IRanges} object indicating region to use for dist
calculation (by default all sites are used) [default: NULL]}
}
\value{
A \code{data.frame} of pairwise distance values
\code{distSTRING}, sites used \code{sitesUsed} and region used
\code{regionUsed}
}
\description{
This function calculates pairwise distances for all combinations
of a \code{AAStringSet}.
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
#aastring2dist(cds2aa(hiv), score=granthamMatrix())
hiv |> cds2aa() |> aastring2dist(score=granthamMatrix())
## create mask
mask1 <- IRanges::IRanges(start=c(11,41,71), end=c(20,50,80))
## use mask
hiv |> cds2aa() |> aastring2dist(score=granthamMatrix(), mask=mask1)
## use region
region1 <- IRanges::IRanges(start=c(1,75), end=c(45,85))
hiv |> cds2aa() |> aastring2dist(score=granthamMatrix(), region=region1)
## use mask and region
hiv |> cds2aa() |> aastring2dist(score=granthamMatrix(),
    mask=mask1, region=region1)
## use asymmetric score matrix
myscore <- granthamMatrix()
myscore[5, 6] <- 0
h <- hiv |> cds2aa() |> aastring2dist(score=myscore, symmetric=FALSE)
h$distSTRING[1:2, 1:2]
}
\seealso{
\code{\link[MSA2dist]{dnastring2dist}}
}
\author{
Kristian K Ullrich
}
