% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aastring2aabin.R
\name{aastring2aabin}
\alias{aastring2aabin}
\title{aastring2aabin}
\usage{
aastring2aabin(aa)
}
\arguments{
\item{aa}{\code{AAStringSet} [mandatory]}
}
\value{
An object of class \code{AAbin}
}
\description{
This function converts an \code{AAStringSet} into an \code{ape}
\code{AAbin}.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATG---CATTGC")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
## convert into AAbin
#aastring2aabin(cds2aa(cds1.cds2.aln))
cds1.cds2.aln |> cds2aa() |> aastring2aabin()
}
\seealso{
\code{\link[seqinr]{as.alignment}}
\code{\link[ape]{as.DNAbin.alignment}}
}
\author{
Kristian K Ullrich
}
