% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesisTesting.R
\name{testEmpirical}
\alias{testEmpirical}
\title{test for significant activity (quantitative analysis) using various empirical
tests (see details)}
\usage{
testEmpirical(
  obj,
  statistic = NULL,
  useControls = TRUE,
  twoSided = FALSE,
  subset = NULL
)
}
\arguments{
\item{obj}{the MpraObject, after running an analysis function}

\item{statistic}{if null [default], the intercept term is used as the score.
An alternate score can be provided by setting 'statistic'. Must be a numeric
vector.}

\item{useControls}{is TRUE and controls are available, use the controls to
establish the background model and compare against. This allows for more
accurate zscores as well as empircal p-values.}

\item{twoSided}{should the p-value be from a two-sided test (default: FALSE,
right-side test)}

\item{subset}{only test a subset of the enhancers in the object (logical,
indices or names). Default is NULL, then all the enhancers are included.}
}
\value{
a data.frame of empirical summary statistics based on the model's 
estimate of slope, or the given statistic. These are:
\itemize{
    \item statistic: the statistic (either the provided, or extracted from 
    the models)
    \item zscore: Z-score of the statistic (number of standard devisations 
    from the mean). If controls are available, the score is based on their 
    distribution: so it's the number of control-sd from the control-mean
    \item mad.score: a median-baed equivalent of the Z-score, with less 
    sensitivity to outlier values. If controls are provided, it's based
    on their distribution.
    \item pval.zscore: a p-value based on the normal approximation of the
    Z-scores
    \item pval.empirical: only available if negative controls are provided. 
    empirical P-value, using the control distribution as the null
}
}
\description{
test for significant activity (quantitative analysis) using various empirical
tests (see details)
}
\examples{
data <- simulateMPRA(tr = rep(2,10), da=NULL, nbatch=2, nbc=15)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
obj <- analyzeQuantification(obj, dnaDesign = ~ batch + barcode, 
                              rnaDesign = ~1)
results <- testEmpirical(obj)

## or test with a different statistic:
aggregated.ratio <- rowSums(data$obs.rna) / rowSums(data$obs.dna)
results <- testEmpirical(obj, aggregated.ratio)
}
