% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraryDepth.R
\name{setDepthFactors}
\alias{setDepthFactors}
\title{Manually set library depth correction factors}
\usage{
setDepthFactors(obj, dnaDepth, rnaDepth)
}
\arguments{
\item{obj}{the MpraObject}

\item{dnaDepth}{library size factors for the DNA data, a numeric vector of 
length of the number of columns in the DNA data matrix}

\item{rnaDepth}{library size factors for the RNA data, a numeric vector of 
length of the number of columns in the RNA data matrix}
}
\value{
the MpraObject with library depth factors
}
\description{
Manually set library depth correction factors
}
\examples{
data <- simulateMPRA(tr = rep(2,10), da=NULL, nbatch=2, nbc=20)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
## set constant depth factors (no depth correction)
obj <- setDepthFactors(obj, dnaDepth = rep(1, NCOL(data$obs.dna)),
                              rnaDepth = rep(1, NCOL(data$obs.rna)))
}
