% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysisFunctions.R
\name{analyzeComparative}
\alias{analyzeComparative}
\title{Run a comparative analysis between conditions}
\usage{
analyzeComparative(
  obj,
  rnaDesign,
  dnaDesign = NULL,
  fit.se = FALSE,
  reducedDesign = NULL,
  correctControls = TRUE,
  verbose = TRUE,
  mode = "classic",
  BPPARAM = NULL
)
}
\arguments{
\item{obj}{the MpraObject}

\item{rnaDesign}{the design for the RNA model.}

\item{dnaDesign}{the design for the DNA model. Only terms that are matched
with the RNA design should be included.}

\item{fit.se}{logical, if TRUE the standard errors of the coefficients
are extracted from the model. These are necessary for computing coefficient-
based testing, but make the model fitting slower. Deafult: FALSE}

\item{reducedDesign}{the design for the reduced RNA model, for a likelihood-
ratio testing scheme. The Reduced design must be nested within the full 
design (i.e all terms in the reduced must be included in the full).}

\item{correctControls}{if TRUE (default), use the negative controls to 
establish the null hypothesis, correcting for systemic bias in the data}

\item{verbose}{print progress reports (default: TRUE)}

\item{mode}{whether to run in classic mode ("classic") or in scalable mode ("scale"). 
Scale mode is only available in situations when each RNA observation has a single
corresponding DNA observation.}

\item{BPPARAM}{a parallelization object created by BiocParallel. This 
overwrites the BPPARAM object set in the object creation.}
}
\value{
the MpraObject with fitted models for the input enhancers
}
\description{
Run a comparative analysis between conditions
}
\examples{
data <- simulateMPRA(tr = rep(2,5), da=c(rep(0,2), rep(1,3)), 
                     nbatch=2, nbc=15)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
## run an LRT-based analysis, as recommnded:
obj <- analyzeComparative(obj, dnaDesign = ~ batch + barcode + condition, 
                              rnaDesign = ~ condition, reducedDesign = ~ 1)
                              
## alternatively, run a coefficient-based analysis:
obj <- analyzeComparative(obj, dnaDesign = ~ batch + barcode + condition, 
                              rnaDesign = ~ condition, fit.se = TRUE)
}
