% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MpraObject.R
\name{MpraObject}
\alias{MpraObject}
\alias{MpraObject,matrix-method}
\alias{MpraObject,SummarizedExperiment-method}
\alias{dnaCounts}
\alias{dnaCounts,MpraObject-method}
\alias{rnaCounts}
\alias{rnaCounts,MpraObject-method}
\alias{dnaAnnot}
\alias{dnaAnnot,MpraObject-method}
\alias{rnaAnnot}
\alias{rnaAnnot,MpraObject-method}
\alias{rowAnnot}
\alias{rowAnnot,MpraObject-method}
\alias{controls}
\alias{controls,MpraObject-method}
\alias{dnaDepth}
\alias{dnaDepth,MpraObject-method}
\alias{rnaDepth}
\alias{rnaDepth,MpraObject-method}
\alias{model}
\alias{model,MpraObject-method}
\title{MpraObject}
\usage{
MpraObject(
  dnaCounts,
  rnaCounts,
  dnaAnnot = NULL,
  rnaAnnot = NULL,
  colAnnot = NULL,
  controls = NA_integer_,
  rowAnnot = NULL,
  BPPARAM = NULL
)

\S4method{MpraObject}{matrix}(
  dnaCounts,
  rnaCounts,
  dnaAnnot = NULL,
  rnaAnnot = NULL,
  colAnnot = NULL,
  controls = NA_integer_,
  rowAnnot = NULL,
  BPPARAM = NULL
)

\S4method{MpraObject}{SummarizedExperiment}(
  dnaCounts,
  rnaCounts,
  dnaAnnot = NULL,
  rnaAnnot = NULL,
  colAnnot = NULL,
  controls = NA,
  rowAnnot = NULL,
  BPPARAM = NULL
)

dnaCounts(obj)

\S4method{dnaCounts}{MpraObject}(obj)

rnaCounts(obj)

\S4method{rnaCounts}{MpraObject}(obj)

dnaAnnot(obj)

\S4method{dnaAnnot}{MpraObject}(obj)

rnaAnnot(obj)

\S4method{rnaAnnot}{MpraObject}(obj)

rowAnnot(obj)

\S4method{rowAnnot}{MpraObject}(obj)

controls(obj)

\S4method{controls}{MpraObject}(obj)

dnaDepth(obj)

\S4method{dnaDepth}{MpraObject}(obj)

rnaDepth(obj)

\S4method{rnaDepth}{MpraObject}(obj)

model(obj)

\S4method{model}{MpraObject}(obj)
}
\arguments{
\item{dnaCounts}{the DNA count matrix, or a SummarizedExperiment object
containing the DNA Counts and column annotations for the DNA data. If the
input is a SummarizedExperiment object, the dnaAnnot (or colAnnot) arguments
will be ignored}

\item{rnaCounts}{the RNA count matrix, or a SummarizedExperiment object
containing the RNA Counts and column annotations for the RNA data. If the
input is a SummarizedExperiment object, the rnaAnnot (or colAnnot) arguments
will be ignored}

\item{dnaAnnot}{data.frame with the DNA column (sample) annotations}

\item{rnaAnnot}{data.frame with the RNA column (sample) annotations}

\item{colAnnot}{if annotations for DNA and RNA are identical, they can be set
at the same time using colAnnot instead of using both rnaAnnot and dnaAnnot}

\item{controls}{IDs of the rows in the matrices that correspond to negative 
control enhancers. These are used to establish the null for quantification
purposes, and to correct systemic bias in comparative analyses. Can be a 
character vectors (corresponding to rownames in the data matrices), logical
or numeric indices.}

\item{rowAnnot}{a data.frame with the row (candidate enhancer) annotations.
The names must match the row names in the DNA and RNA count matrices.}

\item{BPPARAM}{a parallelization backend using the BiocParallel package, see
more details [here](http://bioconductor.org/packages/release/bioc/html/BiocParallel.html)}

\item{obj}{The MpraObject to extract properties from}
}
\value{
an initialized MpraObject
}
\description{
The main object MPRAnalyze works with, contains the input data,
associated annotations, model parameters and analysis results.
}
\section{Accessors}{

MpraObject properties can be accessed using accessor functions
\describe{
\item{dnaCounts}{the DNA count matrix}
\item{rnaCounts}{the RNA count matrix}
\item{dnaAnnot}{data.frame with the DNA column (sample) annotations}
\item{ranAnnot}{data.frame with the RNA column (sample) annotations}
\item{rowAnnot}{data.frame with the row (candidate enhancers) annotations}
\item{model}{the distributional model used. the Gamma-Poisson convolutional 
model is used by default. see \code{\link{setModel}}}
\item{dnaDepth}{The library size correction factors computed for the DNA
libraries. These are computed by the \code{\link{estimateDepthFactors}} 
function and can be set manually using the \code{\link{setDepthFactors}}
function}
\item{rnaDepth}{The library size correction factors computed for the RNA
libraries These are computed by the \code{\link{estimateDepthFactors}} 
function and can be set manually using the \code{\link{setDepthFactors}}
function}
}
}

\examples{
data <- simulateMPRA(tr = rep(2,10), da=c(rep(2,5), rep(2.5,5)), 
                     nbatch=2, nbc=20)
## use 3 of the non-active enhancers as controls
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot,
                  controls = as.integer(c(1,2,4)))
## alternatively, initialize the object with SummarizedExperiment objects:
\dontrun{
se.DNA <- SummarizedExperiment(list(data$obs.dna), colData=data$annot)
se.RNA <- SummarizedExperiment(list(data$obs.rna), colData=data$annot)
obj <- MpraObject(dnaCounts = se.DNA, rnaCounts = rna.se, 
                  controls = as.integer(c(1,2,4)))
}
dnaCounts <- dnaCounts(obj)
rnaCounts <- rnaCounts(obj)
dnaAnnot <- dnaAnnot(obj)
rnaAnnot <- rnaAnnot(obj)
controls <- controls(obj)
rowAnnot <- rowAnnot(obj) 
model <- model(obj)

obj <- estimateDepthFactors(obj, lib.factor=c("batch", "condition"))
dnaDepth <- dnaDepth(obj)
rnaDepth <- rnaDepth(obj)

}
