% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ChrEpi}
\alias{ChrEpi}
\alias{ce.colAnnot}
\alias{ce.dnaCounts}
\alias{ce.rnaCounts}
\alias{ce.control}
\title{Sample MPRA data}
\format{
\describe{
\item{ce.colAnnot}{
Column annotations for each column (sample) in the data matrices
\describe{
\item{batch}{batch identifier, factor}
\item{condition}{condition identifier, factor. WT corresponds to chromosomal
and MT corresponds to episomal}
\item{barcode}{barcode identifier, factor}
}
}
\item{ce.dnaCounts}{DNA observations}
\item{ce.rnaCounts}{DNA observations}
\item{ce.control}{indices of control enhancers}
}

An object of class \code{data.frame} with 40 rows and 3 columns.

An object of class \code{matrix} with 110 rows and 40 columns.

An object of class \code{matrix} with 110 rows and 40 columns.

An object of class \code{logical} of length 110.
}
\source{
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC5204343/}
}
\usage{
data(ChrEpi)

ce.colAnnot

ce.dnaCounts

ce.rnaCounts

ce.control
}
\description{
A subset of MPRA data from Inoue et al., comparing enhancer activity of
episomal constructs vs. chromosomally integrated constructs (integration
was performed with a lentivirus). Data included negative control enhancers,
multiple batches and barcodes, a subsample of which are included in this
sample data for runtime purposes.
}
\keyword{datasets}
