% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppInp.R
\name{ppRnaInp}
\alias{ppRnaInp}
\title{Prepare input RNA data to run PARADIGM}
\usage{
ppRnaInp(rna_tumor_mat, rna_normal_mat, rna_n_sd = 2, threads = 1)
}
\arguments{
\item{rna_tumor_mat}{A matrix of RNA data from tumor samples with rows as
genes and columns as samples}

\item{rna_normal_mat}{A matrix of RNA data from normal samples with rows
as genes and columns as samples}

\item{rna_n_sd}{Standard deviation range from fitted normal samples to
define RNA state. Default: 2, i.e. 2*sd}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
A SummarizedExperiment of RNA state for PARADIGM
}
\description{
Prepare input RNA data to run PARADIGM
}
\examples{

ftumor = system.file('extdata/TcgaInp/log10fpkmP1_tumor.rds', package='MPAC')
fnorm = system.file('extdata/TcgaInp/log10fpkmP1_normal.rds', package='MPAC')
rna_tumor_mat = readRDS(ftumor)
rna_norm_mat  = readRDS(fnorm)

ppRnaInp(rna_tumor_mat, rna_norm_mat, threads=2)

}
