% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltConMtf.R
\name{pltConMtf}
\alias{pltConMtf}
\title{Plot consensus pathway submodules}
\usage{
pltConMtf(grphl, proteins = NULL)
}
\arguments{
\item{grphl}{A list of igraph objects representing consensus pathway
submodules. It is the output from \code{conMtf()}.}

\item{proteins}{A vector of protein symbols to highlight in the plot.
Default: no protein will be highlighted.}
}
\value{
a plot of consensus pathway submodules
}
\description{
Plot consensus pathway submodules
}
\examples{

grphl <- system.file('extdata/pltMtfPrtIPL/grphl.rds',package='MPAC') |>
         readRDS()

proteins <- system.file('extdata/TcgaInp/inp_focal.rds', package='MPAC') |>
            readRDS() |> rownames() |> c('CD3G')

pltConMtf(grphl, proteins) |> print()

}
