% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clSamp.R
\name{clSamp}
\alias{clSamp}
\title{Cluster samples by pathway over-representation}
\usage{
clSamp(ovrmat, n_neighbors = 10, n_random_runs = 200, threads = 1)
}
\arguments{
\item{ovrmat}{A matrix of gene set over-representation adjusted p-values
with rows as gene sets and columns as samples. It is the
output from \code{ovrGMT()}.}

\item{n_neighbors}{Number of neighbors for clustering. A larger number is
recommended if the size of samples is large. Default: 10.}

\item{n_random_runs}{Number of random runs. Due to randomness introduced
to the Louvain algorithm in R igraph 1.3.0
(https://github.com/igraph/rigraph/issues/539), a large
number of runs are recommended to evaluate randomness
in the clustering results. Default: 200, which shall be
safe for sample size < 50. Please increase it
accordingly for a larger sample size.}

\item{threads}{Number of threads to run in parallel. Default: 1}
}
\value{
A data table with each row representing one clustering result, and
the first column denotes the number of occurrences of a clustering
result and the rest of columns indicating each sample's cluster
index. Rows are ordered by the number of occurrences from high to
low.
}
\description{
Cluster samples by pathway over-representation
}
\examples{

fovr = system.file('extdata/clSamp/ovrmat.rds', package='MPAC')
ovrmat = readRDS(fovr)

clSamp(ovrmat)

}
