% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsim_functions.R
\name{sparsim_create_simulation_parameter}
\alias{sparsim_create_simulation_parameter}
\title{Create SPARSim simulation parameter}
\usage{
sparsim_create_simulation_parameter(
  intensity,
  variability,
  library_size,
  feature_names = NA,
  sample_names = NA,
  condition_name = NA,
  intensity_2 = NULL,
  variability_2 = NULL,
  p_bimod = NULL
)
}
\arguments{
\item{intensity}{Array of gene expression intensity values}

\item{variability}{Array of gene expression variability values}

\item{library_size}{Array of library size values}

\item{feature_names}{Array of feature names. It must be of the same length of \code{intensity} array. If NA (default), feature will be automatically named "gene_1", "gene_2", ... "gene_<N>", where N = length(intensity)}

\item{sample_names}{Array of sample names. It must be of the same length of \code{library_size} array. If NA (defatul), sample will be automatically named "<condition_name>_cell1", "<condition_name>_cell2", ..., "<condition_name>_cell<M>", where M = length(library_size)}

\item{condition_name}{Name associated to the current experimental condition. If NA (default), it will be set to "cond<l1><l2>", where l1 and l2 are two random letters.}

\item{intensity_2}{Array of gene expression intensity values for the second expression mode, if simulating genes with bimodal gene expression. Entries containing \code{NAs} will be ignored. If NULL (default), no bimodal gene expression is simulated.}

\item{variability_2}{Array of gene expression variability values for the second expression mode, if simulating genes with bimodal gene expression. If NULL (default), no bimodal gene expression is simulated.}

\item{p_bimod}{Array of bimodal gene expression probabilities; the i-th value indicates the probability \code{p} of the i-th gene to be expressed in the first mode
(i.e. the one specified in the i-th entries of parameters \code{intensity} and \code{variability}); with probability \code{1-p} the i-th gene will be expressed in the second mode (i.e. the one specified in the i-th entries of parameters \code{intensity_2} and \code{variability_2})}
}
\value{
SPARSim simulation parameter describing one experimental condition
}
\description{
Function to create a SPARSim simulation parameter.
This function is a copy of the `SPARSIM_create_simulation_parameter` function from the 
`SPARSim` package (v0.9.5), originally developed by Giacomo Baruzzo, 
Ilaria Patuzzi, Barbara Di Camillo (2020). The original package is licensed 
under the GPL-3 license.
To simulate N feature (e.g. genes), user must specify N values of gene expression level and gene expression variability in the function input parameters \code{intensity} and \code{variability}, respectively.
To simulate M samples (i.e. cells), user must specify M values of sample library size in the function input parameter \code{library_size}.
}
\details{
User can optionally specify the names to assign at the single feature and sample to simulate (function input parameters \code{feature_names} and \code{sample_names}, respectively,
as well as the name of the experimental condition (function input parameter \code{condition_name}). If the user does not specify such information, the function will set some default values.

To simulate T different experimental conditions in a single count table, then T different simulation parameters must be created.
}
