% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_MOSim.R
\name{sc_mosim}
\alias{sc_mosim}
\title{sc_mosim}
\usage{
sc_mosim(
  omics,
  cellTypes,
  numberReps = 1,
  numberGroups = 1,
  diffGenes = NULL,
  minFC = 0.25,
  maxFC = 4,
  numberCells = NULL,
  mean = NULL,
  sd = NULL,
  noiseRep = 0.1,
  noiseGroup = 0.5,
  regulatorEffect = NULL,
  associationList = NULL,
  feature_no = 8000,
  clusters = 3,
  cluster_size = NULL,
  TF = FALSE,
  TFdf = NULL
)
}
\arguments{
\item{omics}{named list containing the omic to simulate as names, which can 
be "scRNA-seq" or "scATAC-seq".}

\item{cellTypes}{list where the i-th element of the list contains the column 
indices for i-th experimental conditions. List must be a named list.}

\item{numberReps}{OPTIONAL. Number of replicates per group}

\item{numberGroups}{OPTIONAL. number of different groups}

\item{diffGenes}{OPTIONAL. If number groups > 1, Percentage DE genes to simulate.
List of vectors (one per group to compare to group 1) where the vector
contains absolute number of genes for Up and Down ex: c(250, 500) or a 
percentage for up, down ex: c(0.2, 0.2). The rest will be NE}

\item{minFC}{OPTIONAL. Threshold of FC below which are downregulated, by 
default 0.25}

\item{maxFC}{OPTIONAL. Threshold of FC above which are upregulated, by default 4}

\item{numberCells}{OPTIONAL. Vector of numbers. The numbers correspond to the number of 
cells the user wants to simulate per each cell type. The length of the 
    vector must be the same as length of \code{cellTypes}.}

\item{mean}{OPTIONAL. Vector of numbers of mean depth per each cell type. Must be specified 
just if \code{numberCells} is specified.The length of the vector must be 
    the same as length of \code{cellTypes}.}

\item{sd}{OPTIONAL. Vector of numbers of standard deviation per each cell type. Must be 
specified just if \code{numberCells} is specified.The length of the vector 
    must be the same as length of \code{cellTypes}.}

\item{noiseRep}{OPTIONAL. Number indicating the desired standard deviation 
between biological replicates.}

\item{noiseGroup}{OPTIONAL. Number indicating the desired standard deviation
between treatment groups}

\item{regulatorEffect}{OPTIONAL. To simulate relationship scRNA-scATAC, list 
of vectors (one per group) where the vector contains absolute number of
regulators for Activator and repressor ex: c(150, 200) or a percentage
for Activator and repressor ex: c(0.2, 0.1). The rest will be NE. If not
provided, no table of association between scRNA and scATAC is outputted.}

\item{associationList}{REQUIRED A 2 columns dataframe reporting peak ids 
related to gene names. If user doesnt have one, load from package
data("associationList")}

\item{feature_no}{OPTIONAL. If only scRNA-seq to simulate or scRNA and scATAC
but no regulatory constraints, total number of features to be distributed 
between the coexpression clusters.}

\item{clusters}{OPTIONAL. Number of co-expression patterns the user wants
to simulate}

\item{cluster_size}{OPTIONAL. It may be inputted by the user. Recommended: 
by default, its the number of features divided by the number of patterns 
to generate.}

\item{TF}{OPTIONAL default is FALSE, if true, extract TF dataframe}

\item{TFdf}{OPTIONAL, default is NULL. If an association matrix of TF and 
Target_gene is given the TF expression values are extracted. If no data.frame
is given, using the association of human TF from 
{https://tflink.net/}}
}
\value{
a list of Seurat object, one per each omic.
}
\description{
Performs multiomic simulation of single cell datasets
}
\examples{
omic_list <- sc_omicData(list("scRNA-seq"))
cell_types <- list('Treg' = c(1:10),'cDC' = c(11:20),'CD4_TEM' = c(21:30),
'Memory_B' = c(31:40))
sim <- sc_mosim(omic_list, cell_types)

}
