% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_coexpression.R
\name{make_cluster_patterns}
\alias{make_cluster_patterns}
\title{make_cluster_patterns}
\usage{
make_cluster_patterns(numcells = 4, clusters = 8)
}
\arguments{
\item{numcells}{Number of different celltypes we are simulating}

\item{clusters}{OPTIONAL. Number of co-expression patterns the user wants
to simulate}
}
\value{
A tibble with number of columns equal to number of celltypes, rows
 according to the number of TRUE/FALSE combinations corresponding to the
 gene expression patterns along the cells
}
\description{
Function to make the tibble with cluster combinations for the gene expression
patterns along the cells
This function is a slightly modified copy of the `make_cluster_patterns` function
from the `Acorde` package (v1.0.0), originally developed by Arzalluz-Luque A, 
Salguero P, Tarazona S, Conesa A. (2022). acorde unravels functionally 
interpretable networks of isoform co-usage from single cell data. Nature communications
1828. DOI: 10.1038/s41467-022-29497-w. The original package is licensed under the 
GPL-3 license.
}
\examples{
patterns <- make_cluster_patterns(numcells = 4, clusters = 8)
cell_types <- list('Treg' = c(1:10),'cDC' = c(11:20),'CD4_TEM' = c(21:30),
'Memory_B' = c(31:40))
patterns <- make_cluster_patterns(numcells = length(cell_types), 
    clusters = 8)

}
