% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateTabulaReport.R
\name{multiPathwayReport}
\alias{multiPathwayReport}
\title{Summarize pathways' info from a list of MultiOmicsPathway objects (MOP)}
\usage{
multiPathwayReport(multiPathwayList, priority_to = NULL)
}
\arguments{
\item{multiPathwayList}{a list of \code{MultiOmicsPathway} objects resulting from
a multi-omics pathway test.}

\item{priority_to}{a vector with the covariates (omic name) that should go
first.}
}
\value{
a data.frame, pathways in rows, overall pvalue of the coxph,
followed by covariates pvalues, in columns.
}
\description{
Given the list of MOPs, it creates the table.
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

MOP_list <- lapply(reactSmall, function(g) {
    fcl <- multiOmicsSurvivalPathwayTest(multiOmics, g,
        survFormula = "Surv(days, status) ~",
        autoCompleteFormula = TRUE,
        useTheseGenes = genesToUse
    )
    fcl
})

pathwaysSummary <- multiPathwayReport(MOP_list)

}
