% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.r
\name{clusterRange}
\alias{clusterRange}
\title{Cluster Range}
\usage{
clusterRange(
  dis,
  range = c(2, 100),
  step = 1,
  cores = 1,
  method = c("pam", "kmeans"),
  data = NULL
)
}
\arguments{
\item{dis}{Distance object}

\item{range}{vector with start and end 'k'}

\item{step}{Integer indicating the incremental number of clusters to add in each iteration}

\item{cores}{Maximum number of CPU cores to use}

\item{method}{Either 'pam' k-mediods or kmeans. Must supply the original data matrix if using kmeans}

\item{data}{Original data matrix}
}
\value{
list of cluster reliability scores by 'k', 'clustering' (the vector solution) and 'reliability' 
as well as 'medoids' labels
}
\description{
This function generate an cluster structure with 'k' groups and computes the cluster reliability score
where 'k' is a range of values
}
\keyword{internal}
