% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOGAMUN.R
\name{mogamun_run}
\alias{mogamun_run}
\title{mogamun_run}
\usage{
mogamun_run(LoadedData, Cores = 1, NumberOfRunsToExecute = 1, ResultsDir = ".")
}
\arguments{
\item{LoadedData}{list returned by mogamun_load_data()}

\item{Cores}{to run MOGAMUN in parallel on the given number of cores (in 
line with the number of physical processor cores) (default = 1)}

\item{NumberOfRunsToExecute}{number of runs (default = 1)}

\item{ResultsDir}{outputs the results in the specified folder}
}
\value{
None
}
\description{
Run the algorithm with the specified values for the evolution 
parameters
}
\examples{

DEGPath <- system.file("extdata/DE/Sample_DE.csv", package = "MOGAMUN")
NodesScoresPath <- 
    system.file("extdata/DE/Sample_NodesScore.csv", package = "MOGAMUN")
LayersPath <- 
    paste0(system.file("extdata/LayersMultiplex", package = "MOGAMUN"), "/")
EvolutionParameters <- mogamun_init(Generations = 1, PopSize = 10)
LoadedData <- 
    mogamun_load_data(
        EvolutionParameters = EvolutionParameters,
        DifferentialExpressionPath = DEGPath,
        NodesScoresPath = NodesScoresPath,
        NetworkLayersDir = LayersPath,
        Layers = "23"
    )
ResultsDir <- system.file("SampleResults", package="MOGAMUN")
mogamun_run(
    LoadedData = LoadedData,
    Cores = 1,
    NumberOfRunsToExecute = 1,
    ResultsDir = ResultsDir
)
}
