% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_discover.R
\name{continuous_discover}
\alias{continuous_discover}
\title{Unsupervised meta-analytical discovery and validation of continuous 
structures in microbial abundance data}
\usage{
continuous_discover(feature_abd, batch, data, control)
}
\arguments{
\item{feature_abd}{feature-by-sample matrix of abundances (proportions or
counts).}

\item{batch}{name of the batch variable. This variable in data should be a
factor variable and will be converted to so with a warning if otherwise.}

\item{data}{data frame of metadata, columns must include batch.}

\item{control}{a named list of additional control parameters. See details.}
}
\value{
a list, with the following components:
\describe{
\item{consensus_scores}{
matrix of identified consensus continuous scores. Columns are the identified 
consensus scores and rows correspond to samples in feature_abd.
}
\item{consensus_loadings}{
matrix of identified consensus loadings. Columns are the identified 
consensus scores and rows correspond to features in feature_abd.
}
\item{mat_vali}{
matrix of validation cosine coefficients of the identified consensus 
loadings. Columns correspond to the identified consensus scores and rows 
correspond to batches.
}
\item{network, communities, mat_cos}{
components for the constructed PC loading network and community
discovery results. \code{network} is a \pkg{igraph} \code{graph}
object for
the constructed network of associated PC loadings. \code{communities} is a  
\code{\link[igraph:communities]{communities}} object for the identified 
consensus loading clusters in \code{network} (output from 
\code{control$cluster_function}). \code{mat_cos} is the matrix of cosine 
coefficients between all selected top PCs from all batches.
}
\item{control}{list of additional control parameters used in the function
call.
}
}
}
\description{
\code{continuous_discover} takes as input a feature-by-sample matrix of 
microbial abundances. It first performs unsupervised continuous structure
discovery (PCA) within each batch. Loadings of top PCs from each batch are
then mapped against each other to identify "consensus" loadings that are 
reproducible across batches with a network community discovery approach with
\pkg{igraph}. The identified consensus loadings/scores can be viewed as 
continuous structures in microbial profiles that are recurrent across batches
and valid in a meta-analyitical sense. \code{continuous_discover} returns, 
among other output, the identified consensus scores for continuous 
structures in the provided microbial abundance profiles, as well as the 
consensus PC loadings which can be used to assign continuous scores to any 
sample with the same set of microbial features.
}
\details{
\code{control} should be provided as a named list of the following components
(can be a subset).
\describe{
\item{normalization}{
character. Similar to the \code{normalization} parameter in 
\code{\link[Maaslin2]{Maaslin2}} but only \code{"TSS"} and \code{"NONE"} are 
allowed. Default to \code{"TSS"} (total sum scaling).
}
\item{transform}{
character. Similar to the \code{transform} parameter in
\code{\link[Maaslin2]{Maaslin2}} but only \code{"AST"} and \code{"LOG"} are 
allowed. Default to \code{"AST"} (arcsine square root transformation).
}
\item{pseudo_count}{
numeric. Pseudo count to add feature_abd before the transformation. Default 
to \code{NULL}, in which case pseudo count will be set automatically to 0 if
\code{transform="AST"}, and half of minimal non-zero values in 
\code{feature_abd} if \code{transform="LOG"}.
}
\item{var_perc_cutoff}{
numeric. A value between 0 and 1 that indicates the percentage variability 
explained to cut off at for selecting top PCs in each batch. Across batches, 
the top PCs that in total explain more than var_perc_cutoff of the total 
variability will be selected for meta-analytical continuous structure 
discovery. Default to 0.8 (PCs included need to explain at least 80% of the 
total variability).
}
\item{cos_cutoff}{
numeric. A value between 0 and 1 that indicates cutoff for absolute cosine
coefficients between PC loadings to construct the method's network with. Once
the top PC loadings from each batch are selected, cosine coefficients between
each loading pair are calculated which indicate their similarity. Loading 
pairs with absolute cosine coefficients surpassing cos_cutoff are then 
considered as associated with each other, and represented as an edge 
between the pair in a PC loading network. Network community discovery can 
then be performed on this network to identified densely connected "clusters"
of PC loadings, which represent meta-analytically recurrent continuous 
structures.
}
\item{cluster_function}{
function. \code{cluster_function} is used to perform community structure 
discovery in the constructed PC loading network. This can be any of the 
network cluster functions provided in \pkg{igraph}. Default to 
\code{\link[igraph]{cluster_optimal}}. Note that this option can be slow for
larger datasets, in which case \code{\link[igraph]{cluster_fast_greedy}} is
recommended.
}
\item{network_plot}{
character. Name for the generated network figure file. Default to 
\code{"clustered_network.pdf"}. Can be set to \code{NULL} in which 
case no output will be generated.
}
\item{plot_size_cutoff}{
integer. Clusters with sizes smaller than or equal to plot_size_cutoff will 
be excluded in the visualized network. Defaul to 2 - visualized clusters 
must have at least three nodes (PC loadings).
}
\item{diagnostic_plot}{
character. Name for the generated diagnostic figure file. Default to 
\code{"continuous_diagnostic.pdf"}. Can be set to \code{NULL} in which 
case no output will be generated.
}
\item{verbose}{
logical. Indicates whether or not verbose information will be printed.
}
}
}
\examples{
data("CRC_abd", "CRC_meta")
fit_continuous <- continuous_discover(feature_abd = CRC_abd,
                                      batch = "studyID",
                                      data = CRC_meta)
}
\author{
Siyuan Ma, \email{siyuanma@g.harvard.edu}
}
