% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateFragmentCenters.R
\name{estimateFragmentCenters}
\alias{estimateFragmentCenters}
\title{estimate center of fragments}
\usage{
estimateFragmentCenters(MD, shift = NULL, draw.on = FALSE)
}
\arguments{
\item{MD}{DBAmmd Object. This Object can be created using \code{DBAmmd()}.}

\item{shift}{can be set if the offset between forward and reverse strand is
known (e.g. 1/2 median fragment size). In this case shift will not be
estimated  (DEFAULT: NULL)}

\item{draw.on}{plot scatterplots for counts on
forward vs reverse strand and histograms of determined shifts
(DEFAULT: FALSE)}
}
\value{
DBAmmd object with updated slots \code{Reads} and \code{MetaData}.
}
\description{
This function computes average shifts between
forward and reverse strand and applies it to estimate fragment centers.
}
\examples{

## Example using a small data set provided with this package

data("MMD")
MMD.1 <- estimateFragmentCenters(MMD)

# To access centers of fragments:
Reads.C <- Reads(MMD.1,'Center')

# To access the determined shifts for each sample:
meta <- metaData(MMD.1)
meta$AnaData$Shifts


}
\seealso{
\code{\link{DBAmmd}}, \code{\link{getPeakReads}},
\code{\link{compHists}}
}

