% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compDists.R
\name{compDists}
\alias{compDists}
\title{Compute distances between Peaks}
\usage{
compDists(MD, dist.method = "MMD", sigma = NULL, run.parallel = TRUE)
}
\arguments{
\item{MD}{DBAmmd Object. This Object can be created using \code{DBAmmd()}.}

\item{dist.method}{specify method used for distances
between samples. Currently only Maximum Mean Discrepancy (MMD)
and Kolmogorov-Smirnov (KS) implemented.
(DEFAULT: 'MMD')}

\item{sigma}{sigma parameter of the RBF kernel,
determining the distance (along the genome) at which fragment counts
decorrelate. If set to NULL, 100 random Peaks are used to determine sigma
heuristically according to the method described in the MMDiff paper [1].
(DEFUALT: NULL)}

\item{run.parallel}{whether to run in parallel
(currently no parallelization implemented)
(DEFAULT: FALSE)}
}
\value{
DBAmmd object with updated slot \code{Dists}
}
\description{
This function computes pairwise distances between histograms
according to the dist.method (MMD, KS). For large data sets it is a bit
time consuming.
}
\examples{

## Example using a small data set provided with this package:

data("MMD")
MMD.1 <- compDists(MMD)

# To inspect the computed distances:
D <- Dists(MMD.1,dist.method='MMD')
head(D)

# To analyse the result:
plotDists(MMD.1)

}
\author{
Gabriele Schweikert \email{G.Schweikert@ed.ac.uk}
}
\references{
[1] Schweikert et al.  BMC Genomics 2013
...
}
\seealso{
\code{\link{DBAmmd}}, \code{\link{plotDists}},
\code{\link{plotDISTS4Peak}}, \code{\link{compPvals}}
}

