% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMDiff2_data.R
\docType{data}
\name{Cfp1-Peaks}
\alias{Cfp1-Peaks}
\title{Peaks for Cfp1-data set}
\format{contains Peaks, a GRanges object with 500 ranges and
3 metadata columns}
\usage{
data('Cfp1-Peaks')
}
\description{
Subset of MACS called Peaks for Cfp-1 data set. Consensus Peaks were created
using diffBind (see below).
}
\examples{
# data was created as follows:
\dontrun{
library('MMDiffBamSubset')
dataDir <- system.file("extdata", package="MMDiffBamSubset")
library('DiffBind')
olddir <- setwd(dataDir)
DBA <- dba(sampleSheet="Cfp1.csv", minOverlap=3)
Peaks <- dba.peakset(DBA, bRetrieve = TRUE)
DBA <- dba.count(DBA, minOverlap=3)
setwd(olddir)
peaks <- dba.peakset(DBA, bRetrieve=TRUE)
C <- Counts(MMD)
idx <- which(C[,1]>150 & C[,3]>150&width(Peaks)>1000&width(Peaks)<5000)
Peaks <- Peaks[idx[1:500]]
}

}
\references{
data taken from Clouaire et al., Genes and Development, 2012.
}
\keyword{data}

