% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/methods.R
\docType{methods}
\name{normalization}
\alias{normalization}
\alias{normalization<-}
\alias{normalization,MLSeq-method}
\alias{normalization,MLSeqModelInfo-method}
\alias{normalization<-,MLSeq,character-method}
\title{Accessors for the 'normalization' slot.}
\usage{
normalization(object)

normalization(object) <- value

\S4method{normalization}{MLSeq}(object)

\S4method{normalization}{MLSeqModelInfo}(object)

\S4method{normalization}{MLSeq,character}(object) <- value
}
\arguments{
\item{object}{an \code{MLSeq} or \code{MLSeqModelInfo} object.}

\item{value}{a character string. One of the available normalization methods for voom-based classifiers.}
}
\description{
This slot stores the name of normalization method which is used while normalizing the count data such
as "deseq", "tmm" or "none"
}
\examples{
\dontrun{
library(DESeq2)
data(cervical)

# a subset of cervical data with first 150 features.
data <- cervical[c(1:150), ]

# defining sample classes.
class <- data.frame(condition = factor(rep(c("N","T"), c(29, 29))))

n <- ncol(data)  # number of samples
p <- nrow(data)  # number of features

# number of samples for test set (30\% test, 70\% train).
nTest <- ceiling(n*0.3)
ind <- sample(n, nTest, FALSE)

# train set
data.train <- data[ ,-ind]
data.train <- as.matrix(data.train + 1)
classtr <- data.frame(condition = class[-ind, ])

# train set in S4 class
data.trainS4 <- DESeqDataSetFromMatrix(countData = data.train,
                   colData = classtr, formula(~ 1))

## Number of repeats (repeats) might change model accuracies ##
# Classification and Regression Tree (CART) Classification
cart <- classify(data = data.trainS4, method = "rpart",
          ref = "T", preProcessing = "deseq-vst",
          control = trainControl(method = "repeatedcv", number = 5,
                                 repeats = 3, classProbs = TRUE))

normalization(cart)
}

}
