% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/association.R
\name{searchDisease}
\alias{searchDisease}
\title{Search for disease EFO identifiers}
\usage{
searchDisease(diseaseName)
}
\arguments{
\item{diseaseName}{The name of a particular disease
(ex. \verb{Alzheimer disease}).}
}
\value{
A \code{character} object containing EFO identifiers.
}
\description{
This function allows to retrieve the Experimental Factor Ontology (EFO)
identifier of a particular disease. This ID is then needed to use the
function \code{\link[=findMirnaSNPs]{findMirnaSNPs()}}.
}
\note{
To retrieve EFO IDs for specific diseases, this function makes use of the
\code{gwasrapidd} package.
}
\examples{
\donttest{
# search the EFO identifier of Alzheimer disease
searchDisease("Alzheimer disease")
}

}
\references{
Ramiro Magno, Ana-Teresa Maia, gwasrapidd: an R package to query, download
and wrangle GWAS catalog data, Bioinformatics, Volume 36, Issue 2, January
2020, Pages 649–650, \url{https://doi.org/10.1093/bioinformatics/btz605}.
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
