% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotDE}
\alias{plotDE}
\title{Represent differentially expressed miRNAs/genes as boxplots, barplots or
violinplots}
\usage{
plotDE(
  mirnaObj,
  features,
  condition = NULL,
  graph = "boxplot",
  linear = TRUE,
  showSignificance = TRUE,
  starSig = TRUE,
  pCol = "adj.P.Val",
  sigLabelSize = 7,
  digits = 3,
  nameAsTitle = FALSE,
  colorScale = NULL,
  fontSize = 12,
  fontFamily = "",
  legend = "top",
  borderWidth = 1,
  allBorders = FALSE,
  grid = FALSE
)
}
\arguments{
\item{mirnaObj}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object
containing miRNA and gene data}

\item{features}{A character vector containing the genes/miRNAs to plot}

\item{condition}{It must be NULL (default) to plot expression based on the
group variable used for differential expression analysis. Alternatively, it
must be a character/factor object that specifies group memberships
(eg. c("healthy, "healthy", "disease", "disease"))}

\item{graph}{The type of plot to produce. It must be one of \code{boxplot}
(default), \code{barplot}, \code{violinplot}}

\item{linear}{Logical, whether to plot expression levels in linear scale
or in log2 space. Default is TRUE in order to use the linear space}

\item{showSignificance}{Logical, whether to display statistical significance
or not. Default is TRUE}

\item{starSig}{Logical, whether to represent statistical significance through
stars. Default is TRUE, and the significance scale is: * for \eqn{p < 0.05},
** for \eqn{p < 0.01}, *** for \eqn{p < 0.001}, and **** for
\eqn{p < 0.0001}. If \code{starSig} is set to FALSE, p-values or adjusted
p-values will be reported on the plot as numbers}

\item{pCol}{The statistics used to evaluate comparison significance. It must
be one of \code{P.Value}, to use unadjusted p-values, and \code{adj.P.Val} (default),
to use p-values corrected for multiple testing}

\item{sigLabelSize}{The size for the labels used to show statistical
significance. Default is 7, which is well suited for representing p-values
as significance stars. However, if \code{starSig} is set to FALSE, the user might
have to downsize this parameter}

\item{digits}{The number of digits to show when p-values are reported as
numbers (when \code{starSig} is FALSE). Default is 3}

\item{nameAsTitle}{Logical, if set to TRUE, the miRNA/gene name will be
added as plot title, and the x-axis and legend will be removed. Note that
this option is only considered if \code{features} contains just one miRNA/gene.
Default is FALSE}

\item{colorScale}{It must be a named character vector where values
correspond to R colors, while names coincide with the groups specified in
the \code{condition} parameter (eg. c("healthy" = "green", "disease" = "red")).
Default is NULL, in order to use the default color scale. Available color
formats include color names, such as 'blue' and 'red', and hexadecimal
colors specified as #RRGGBB}

\item{fontSize}{The base size for text elements within the plot.
Default is 12}

\item{fontFamily}{The base family for text elements within the plot}

\item{legend}{The position of the legend. Allowed values are \code{top},
\code{bottom}, \code{right}, \code{left} and \code{none}. The default setting is \code{top} to show
a legend above the plot. If \code{none} is specified, the legend will not be
included in the graph.}

\item{borderWidth}{The width of plot borders (default is 1)}

\item{allBorders}{Logical, whetether to show all panel borders, or just the
bottom and left borders. Default is FALSE}

\item{grid}{Logical, whether to show grid lines or not. Default is FALSE}
}
\value{
An object of class \code{ggplot} containing the plot.
}
\description{
This function is able to produce boxplots, barplots and violinplots that are
useful to visualize miRNA and gene differential expression. The user just
has to provide a vector of interesting miRNA/genes that he wants to plot
(e.g. "hsa-miR-34a-5p", "hsa-miR-146b-5p", "PAX8"). The chart type can be
specified through the \code{graph} parameter.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# produce a boxplot for PAX8 and miR-34a-5p
plotDE(obj, features = c("hsa-miR-34a-5p", "PAX8"))

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
