% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch-correction.R
\name{batchCorrection}
\alias{batchCorrection}
\title{Correct for batch effects in miRNA and gene expression measurements}
\usage{
batchCorrection(
  mirnaObj,
  assay,
  batch = NULL,
  batch2 = NULL,
  covariates = NULL,
  includeWsva = FALSE,
  n.sv = 1L,
  weight.by.sd = TRUE
)
}
\arguments{
\item{mirnaObj}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object
containing miRNA and gene data}

\item{assay}{The expression matrix to correct. It must be one of \code{genes}
and \code{microRNA}}

\item{batch}{It must be the name of a variable present in the \code{colData} of
a \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object (eg. "disease"), or,
alternatively, it must be a \code{character}/\code{factor} object that defines batch
memberships. See the \strong{details} section for additional information}

\item{batch2}{It must be the name of a variable present in the \code{colData} of
a \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object (eg. "disease"), or,
alternatively, it must be a \code{character}/\code{factor} object that defines
another series of batches that have additive effects to those specified
in \code{batch}. See the \strong{details} section for additional information}

\item{covariates}{Additional numeric covariates that we want to correct for.
It must be a \code{character} vector containing the names of numeric variables
present in the \code{colData} of a \code{\link[=MirnaExperiment-class]{MirnaExperiment}}
object (eg. \code{c("age", "RIN", "quantity")}), or, alternatively, it must be a
simple \code{matrix} object. See the \strong{details} section for additional
information}

\item{includeWsva}{Logical, whether to correct for surrogate variables or
not. Default is FALSE}

\item{n.sv}{The number of surrogate variables to estimate}

\item{weight.by.sd}{Logical, whether to specifically tune the surrogate
variables to the more variable genes or not. Default is TRUE}
}
\value{
A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object containing batch
effect-corrected expression matrices.
}
\description{
This function allows to remove unwanted batch effects from miRNA and gene
expression matrices. In particular, this function fits a linear model to
miRNA/gene expression levels, and then removes the variability caused by
batch effects. Furthermore, a weighted surrogate variable analysis (WSVA)
can also be included to remove the effects due to surrogate variables.
If batch effects are present, it is crucial to remove them with this
function before moving to correlation analysis.
}
\details{
Batch effects consist in unwanted sources of technical variation that
confound expression variability and limit downstream analyses. Since the
reliability of biological conclusions of integrative miRNA-mRNA analyses
depends on the association between miRNA and gene expression levels, it is
pivotal to ensure that expression measurements are not affected by technical
variations. In this regard, if batch effects are noticed in the data, the
user should run this function before using the \code{\link[=mirnaIntegration]{mirnaIntegration()}}
function to perform a correlation analysis.

Usually, given a \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object, the user
should specify:
\itemize{
\item the \code{assay} from which we want to remove batch effects (one between
\code{genes} and \code{microRNA});
\item the \code{batch} variable, which is a variable that defines the different
batches;
\item the \code{batch2} variable, which can be included to correct for a second
series of batches that have additive effects to those specified in \code{batch};
\item the \code{covariates} variables, which allows correction for one or more
continuous numeric effects.
}

In particular, \code{batch} and \code{batch2} could be provided as the names of
covariates included in the \code{colData} of a
\code{\link[=MirnaExperiment-class]{MirnaExperiment}} object. Alternatively, they can
be \code{character}/\code{factor} objects that declare batch memberships.
Similarly, \code{covariates} can be supplied as a vector containing the names
of numeric variables listed in the \code{colData} of
\code{\link[=MirnaExperiment-class]{MirnaExperiment}} objects, or they can be provided
as a simple \code{matrix}.

Additionally, the influence of unknown sources of technical variation can
be removed by including surrogate variables estimated through WSVA. To do
so, we can set \code{includeWsva} to TRUE, and then we can specify the number of
surrogate variables to use through the \code{n.sv} parameter. Further, the
surrogate variables can be tuned to the more variable genes by setting
\code{weight.by.sd} to TRUE.

Please note that we only recommend to remove batch effects directly from
expression measurements prior to correlation analysis. This function
can't be used to remove batch effects before differential expression
analysis, because for that purpose, it is better to include batch variables
in the linear model. In this way, we do not underestimate the residual
degrees of freedom, so that the calculated standard errors, t-statistics
and p-values are not overoptimistic.
}
\note{
To estimate surrogate variables and to remove batch effects from expression
data, MIRit uses the \code{\link[limma:wsva]{limma::wsva()}} and \code{\link[limma:removeBatchEffect]{limma::removeBatchEffect()}}
functions, respectively.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# correct batch effects due to the patient from miRNA expression matrix
obj <- batchCorrection(obj, "microRNA", batch = "patient")

}
\references{
Ritchie ME, Phipson B, Wu D, Hu Y, Law CW, Shi W, Smyth GK (2015). “limma
powers differential expression analyses for RNA-sequencing and microarray
studies.” Nucleic Acids Research, 43(7), e47. \url{doi:10.1093/nar/gkv007}.
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
