% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning_aggregation.R
\name{binRegion}
\alias{binRegion}
\title{Divide region into similarly sized bins.}
\usage{
binRegion(start, end, bins, idDF = NULL, strand = "*")
}
\arguments{
\item{start}{Coordinate for beginning of range/range.}

\item{end}{Coordinate for end of range/region.}

\item{bins}{How many bins to divide this range/region.}

\item{idDF}{A string/vector of strings that has chromosome (e.g. "chr1") 
for given start and end values}

\item{strand}{"strand" column of the data.table (or single
strand value if binRegion is only used on one region). Default is "*".}
}
\value{
A data.table, expanded to nrow = number of bins, with these id columns:
     id: region ID
     binID: repeating ID (this is the value to aggregate across)
     ubinID: unique bin IDs
}
\description{
Given a start, end, and number of bins, to divide, 
this function will split the regions into bins.
Bins will be only approximately the same size, due to rounding.
(they should not be more than 1 different).
}
\details{
Use case: take a set of regions, like CG islands, and bin them; now you can
aggregate signal scores across the bins, giving you an aggregate signal
in bins across many regions of the same type.

In theory, this just runs on 3 values, but you can run it inside a 
data.table j expression to divide a bunch of regions in the same way.
}
\examples{
library(data.table)
start <- c(100, 1000, 3000)
end <- c(500, 1400, 3400)
chr <- c("chr1", "chr1", "chr2")
strand <- c("*", "*", "*")
# strand not included in object 
# since MIRA assumes "*" already unless given something else
regionsToBinDT <- data.table(chr, start, end)
numberOfBins <- 15
# data.table "j command" using column names and numberOfBins variable
binnedRegionDT <- regionsToBinDT[, binRegion(start, end, numberOfBins, chr)]
}
