% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ajive.R
\name{ajive_decomp}
\alias{ajive_decomp}
\title{Integrative analysis for modes of joint variation}
\usage{
ajive_decomp(
  se,
  ini_rank = c(20, 20),
  test = "gene_data",
  use_marker = FALSE,
  level = "bulk",
  plot = FALSE,
  score = "cns_1",
  group_var = "disease",
  scatter = FALSE,
  scatter_x,
  scatter_y,
  refactor_loading = FALSE
)
}
\arguments{
\item{se}{A `SummarizedExperiment` object with bulk expression data frame
contained in `counts` slot.
In addition, data measured on the same set of samples in `metadata` slot is
required.}

\item{ini_rank}{A vector with each element corresponds to a initial signal
rank for AJIVE decomposition.
Please refer to the original paper (Feng, Qing, et al. "Angle-based joint
and individual variation explained." Journal of multivariate analysis 166
(2018): 241-265.)
on the choice of initial ranks.}

\item{test}{A character string indicate which data are used as a secondary
data block measured on the same set of samples.}

\item{use_marker}{If TRUE, only markers contained in `ref_gene` are used.}

\item{level}{A character string indicate if the integrative analysis should
be done at cell type specific level and
which cell type should be used. By default, the integrative analysis is done
at bulk level.}

\item{plot}{If TRUE, visualization on common normalized scores across 
different data sources will be stored as an element (`cns_plot`) in 
`metadata` slot.}

\item{score}{A character of variable name indicating which common
normalized score is used for boxplot and ridge plot (valid if plot = TRUE).}

\item{group_var}{A character of variable name indicating which variable is
used as the group variable to compare common normalized scores 
(valid if plot = TRUE).}

\item{scatter}{A logical value indicating whether to make scatter plot or
not. Only valid when the joint rank is at least two (valid if plot = TRUE).}

\item{scatter_x}{A character of variable name indicating which common
normalized scores on horizontal axis (valid if plot = TRUE).}

\item{scatter_y}{A character of variable name indicating which common
normalized scores on vertical axis (valid if plot = TRUE).}

\item{refactor_loading}{A logical value indicating whether to output the 
refactor joint loadings for each data source. A smaller value indicates 
features with the highest variance explained within the joint space.}
}
\value{
A `SummarizedExperiment`. The results from AJIVE will be stored as
an element (`ajive_res`) in `metadata` slot.
The generated common normalized scores will be stored as an element (`cns`)
in `metadata` slot. The visualization of the common normalized scores will 
be stored as an element (`cns_plot`) in `metadata` slot.
}
\description{
This function returns a `SummarizedExperiment` object including results from
AJIVE (Angle based Joint and Individual Variation Explained),
an integrative analysis tool, and common normalized scored based on it.
This implemented the AJIVE algorithm 
(see R version of AJIVE package (https://github.com/idc9/r_jive)
or detailed manuscript at https://arxiv.org/pdf/1704.02060.pdf)
an integrative analysis method.
It is useful when there are multiple data matrices measured on the same set
of samples.
It decomposes each data matrix as three parts: (1) Joint variation across
data types
(2) Individual structured variation for each data type and (3) Residual
noise.
Common normalized scores are one of the desirable output to explore the
joint behavior that is shared by different data sources.
}
\examples{
data(se)
metadata(se)$gene_data <- metadata(se)$gene_data[seq_len(100),] #reduce time
se <- ajive_decomp(se, use_marker = TRUE)

}
