% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultsSet_topRDAhits.R
\name{topRDAhits}
\alias{topRDAhits}
\title{Get the top features associated with the RDA}
\usage{
topRDAhits(object, tPV = 0.05)
}
\arguments{
\item{object}{\code{ResultSet}}

\item{tPV}{numeric with the p-value threshold. Only features with a p-values below this threshold will be shown.}
}
\value{
data.frame with the features, the component, the correlation and the p-value
}
\description{
Get a list of the features significantly associated to the first two RDA components
}
\examples{
if (require(minfiData) & require(GenomicRanges)){
set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
model <- model.matrix(~set$sex)
rda <- runRDA(set, model)
topRDAhits(rda)
}
}
