% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMetaData.R
\name{getMetaData}
\alias{getMetaData}
\title{Constructor for metadata}
\usage{
getMetaData(path, id = "subj_id", familyId = "family_id",
  fatherId = "father_id", motherId = "mother_id", bamPath = "bam_path")
}
\arguments{
\item{path}{The path pointing to the file that contains information on each
subject in the dataset.}

\item{id}{The column name that identifies each sample. Defaults to 'subj_id'.}

\item{familyId}{The column name that identifies which family the sample
belongs to. Defaults to 'family_id'.}

\item{fatherId}{The column name that identifies the id of the father. 
Defaults to 'father_id'.}

\item{motherId}{The column name that identifies the id of the mother.
Defaults to 'mother_id'.}

\item{bamPath}{The column name that identifies where to find the bam file
for each subject. Defaults to 'bam_path'.}
}
\value{
Returns a \code{data.frame} of required sample information for 
running MDTS.
}
\description{
This function allows constructor of phenotype information necessary for 
downstream analysis. See format of required fields. Function will also 
rearrange the rows such that trios are grouped together - with proband first,
mother second, and father third.
}
\examples{
meta <- getMetaData(
'https://raw.githubusercontent.com/JMF47/MDTSData/master/data/pD.ped')
}
