% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThresholdBic.R
\name{ThresholdBic}
\alias{ThresholdBic}
\alias{ThresholdBic}
\alias{PC1Align}
\alias{ForkClassifier}
\title{Methods for defining a bicluster}
\usage{
ThresholdBic(cor.vec, sort.order, pc1, samp.sig = 0)

PC1Align(gem, pc1, cor.vec, sort.order, bic)

ForkClassifier(pc1, samp.num)
}
\arguments{
\item{cor.vec}{Correlation vector (output of \code{CVEval()}).}

\item{sort.order}{Order of samples (output of \code{SampleSort()}).}

\item{pc1}{PC1 values for samples (output of \code{PC1VecFun}).}

\item{samp.sig}{Value between 0 and 1 determining number of samples in bicluster}

\item{gem}{Gene expression matrix containing genes as rows and samples as columns.}

\item{bic}{bicluster (output of \code{ThresholdBic()})}

\item{samp.num}{Number of samples in the bicluster}
}
\value{
Defined bicluster
}
\description{
A bicluster is the fundamental result found using MCbiclust. These
three functions are essential for the precise definition of these
biclusters.
}
\details{
\code{ThresholdBic()} takes as its main inputs the correlation vector 
(output of \code{CVEval()}), sample ordering (output of
\code{SampleSort()}), PC1 vector (output of \code{PC1VecFun}) and returns
a list of the genes and samples which belong to the bicluster according 
to a certain level of significance.

\code{PC1Align()} is a function used once the bicluster has been found to
ensure that the upper fork samples (those with higher PC1 values) correspond
to those samples that have genes with positive correlation vector values
up-regulated.

\code{ForkClassifier()} is a function used to classify which samples are in
the upper or lower fork.
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- (row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

set.seed(102)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 1000)

CCLE.sort <- SampleSort(gem = CCLE.mito,seed = CCLE.seed,sort.length = 11)

# Full ordering are in Vignette_sort in sysdata.rda
CCLE.samp.sort <- MCbiclust:::Vignette_sort[[1]]

CCLE.pc1 <- PC1VecFun(top.gem = CCLE.mito,
                      seed.sort = CCLE.samp.sort,
                      n = 10)

CCLE.cor.vec <-  CVEval(gem.part = CCLE.mito,
                            gem.all = CCLE_small,
                            seed = CCLE.seed,
                            splits = 10)

CCLE.bic <- ThresholdBic(cor.vec = CCLE.cor.vec,sort.order = CCLE.samp.sort,
                         pc1 = as.numeric(CCLE.pc1))

CCLE.pc1 <- PC1Align(gem = CCLE_small, pc1 = CCLE.pc1,
                     cor.vec = CCLE.cor.vec ,
                     sort.order = CCLE.samp.sort,
                     bic =CCLE.bic)

CCLE.fork <- ForkClassifier(CCLE.pc1, samp.num = length(CCLE.bic[[2]]))

}
