% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleSort.R
\name{SampleSort}
\alias{SampleSort}
\alias{SampleSort}
\alias{MultiSampleSortPrep}
\title{Methods for ordering samples}
\usage{
SampleSort(gem, seed, num.cores = 1, sort.length = NULL)

MultiSampleSortPrep(gem, av.corvec, top.genes.num, groups, initial.seeds)
}
\arguments{
\item{gem}{Gene expression matrix with genes as rows and samples as columns}

\item{seed}{Sample seed of highly correlating genes}

\item{num.cores}{Number of cores used in parallel evaluation}

\item{sort.length}{Number of samples to be sorted}

\item{av.corvec}{List of average correlation vector}

\item{top.genes.num}{Number of the top genes in correlation vector to use for sorting samples}

\item{groups}{List showing what runs belong to which correlation vector group}

\item{initial.seeds}{List of sample seeds from all runs}
}
\value{
Order of samples by strength to correlation pattern
}
\description{
After finding an initial bicluster with \code{FindSeed()} the next step is
to extend the bicluster by ordering the remaining samples by how they 
preserve the correlation found.
}
\details{
\code{SampleSort()} is the basic function that achieves this, it takes the
gene expression matrix, seed of samples, and also has options for the number
of cores to run the method on and the number of samples to sort.

\code{MultiSampleSortPrep()} is a preparation function for \code{SampleSort()}
when MCbiclust has been run multiple times and returns a list of gene expression
matrices and seeds for each `distinct` bicluster found.
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- (row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

set.seed(102)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 1000)

CCLE.sort <- SampleSort(gem = CCLE.mito,seed = CCLE.seed,sort.length = 11)

# Full ordering are in Vignette_sort in sysdata.rda
CCLE.samp.sort <- MCbiclust:::Vignette_sort[[1]]

CCLE.pc1 <- PC1VecFun(top.gem = CCLE.mito,
                      seed.sort = CCLE.samp.sort,
                      n = 10)

CCLE.cor.vec <-  CVEval(gem.part = CCLE.mito,
                            gem.all = CCLE_small,
                            seed = CCLE.seed,
                            splits = 10)

CCLE.bic <- ThresholdBic(cor.vec = CCLE.cor.vec,sort.order = CCLE.samp.sort,
                         pc1 = as.numeric(CCLE.pc1))

CCLE.pc1 <- PC1Align(gem = CCLE_small, pc1 = CCLE.pc1,
                     cor.vec = CCLE.cor.vec ,
                     sort.order = CCLE.samp.sort,
                     bic =CCLE.bic)

CCLE.fork <- ForkClassifier(CCLE.pc1, samp.num = length(CCLE.bic[[2]]))

}
