\name{pratio}
\alias{pratio}

\title{
Calculation of Psi(\eqn{\psi})
}
\description{
Psi is also called polar ratio. 

\deqn{\psi = max(\frac{min(X_A)}{max(X_B)+1},\frac{min(X_B)}{max(X_A)+1})}.
}   
\usage{
pratio(xx, na, nb)
}

\arguments{
  \item{xx}{
count data of RNA reads generated by next generation sequencing.
}
  \item{na}{
number of replicate libraries in condition A.
}
  \item{nb}{
number of replicate libraries in condition B.
}
}
\details{
Psi is defined as
\deqn{\psi = max(\frac{min(X_A)}{max(X_B)+1},\frac{min(X_B)}{max(X_A)+1})}
It is used to measure overlap of two subdatasets. \eqn{\psi>1}, these two subdatasets have a gap, not overlap.  \eqn{\psi<1} indicates that two subdatasets overlap.
}
\value{

\item{pratio}{pratio list}

}
\references{
Yuan-De Tan Anita M. Chandler, Arindam Chaudhury, and Joel R. Neilson(2015) A Powerful Statistical Approach for Large-scale Differential Transcription Analysis. \emph{Plos One}. 2015 DOI: 10.1371/journal.pone.0123658. 
}
\author{
Yuan-De Tan
\email{tanyuande@gmail.com}
}

\seealso{
   \code{\link{mbetattest}}, \code{\link{oddratio}}
}
\examples{
XX<-matrix(NA,2,8)
XX[1,]<-c(112,122, 108,127,302, 314, 322, 328)
XX[2,]<-c(511, 230, 754, 335,771, 842, 1014,798)
#XX
#     [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8]
#[1,]  112  122  108  127  302  314  322  328
#[2,]  511  230  754  335  771  842 1014  798
pratio(xx=XX,na=4,nb=4)
}

\keyword{ overlap }
\keyword{gap}
