% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_corrections.R
\name{mbecRUV4}
\alias{mbecRUV4}
\title{Remove Unwanted Variation 4 (RUV-4)}
\usage{
mbecRUV4(
  input.obj,
  model.vars,
  type = c("clr", "otu", "tss"),
  nc.features = NULL
)
}
\arguments{
\item{input.obj}{phyloseq object or numeric matrix (correct orientation is
handeled internally)}

\item{model.vars}{Vector of covariate names. First element relates to batch.}

\item{type}{Which abundance matrix to use, one of 'otu, tss, clr'. DEFAULT is
'clr'.}

\item{nc.features}{(OPTIONAL) A vector of features names to be used as
negative controls in RUV-3. If not supplied, the algorithm will use an 'lm'
to find pseudo-negative controls}
}
\value{
A vector of p-values that indicate significance of the batch-effect
for the features.
}
\description{
The updated version of RUV-2 also incorporates the residual matrix
(w/o treatment effect) to estimate the unknown BEs. To that end it follows
the same procedure in case there are no negative control variables and
computes pseudo-controls from the data via l(m)m. As RUV-2, this algorithm
also uses the parameter 'k' for the number of latent factors. RUV-4 brings
the function 'getK()' that estimates this factor from the data itself. The
calculated values are however not always reliable. A value of k=0 fo example
can occur and should be set to 1 instead.
}
\details{
The input for this function is supposed to be an MbecData object that
contains total sum-scaled and cumulative log-ratio transformed abundance
matrices. Output will be a vector of p-values.
}
\keyword{Assessment}
\keyword{Batch-Effect}
\keyword{Correction}
