% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_plots.R
\name{mbecPVCAStatsPlot}
\alias{mbecPVCAStatsPlot}
\title{Plot Proportion of Variance for PVCA}
\usage{
mbecPVCAStatsPlot(pvca.obj)
}
\arguments{
\item{pvca.obj, }{output of 'mbecVarianceStats' with method pvca}
}
\value{
A ggplot2 box-plot object.
}
\description{
Covariate-Variances as modeled by PVCA will be displayed as box-plots.
It works with the output of 'mbecVarianceStats()' for the method 'pvca'.
Format of this output is a data.frame that contains a column for every model
variable and as many rows as there are features (OTUs, Genes, ..). Multiple
frames may be used as input by putting them into a list - IF the data.frames
contain a column named 'type', this function will use 'facet_grid()' to
display side-by-side panels to enable easy comparison.
}
\examples{
# This will return a paneled plot that shows results for the variance
# assessment.
data(dummy.mbec)
df.var.pvca <- mbecModelVariance(input.obj=dummy.mbec,
model.vars=c('batch','group'), method='pvca', type='clr')
plot.pvca <- mbecPVCAStatsPlot(pvca.obj=df.var.pvca)
}
\keyword{plot}
\keyword{proportion}
\keyword{pvca}
\keyword{variance}
