% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecPCA,MbecData-method}
\alias{mbecPCA,MbecData-method}
\title{Principal Component Analysis Plot for MbecData}
\usage{
\S4method{mbecPCA}{MbecData}(
  input.obj,
  model.vars = c("batch", "group"),
  pca.axes = c(1, 2),
  type = "clr",
  label = character(),
  return.data = FALSE
)
}
\arguments{
\item{input.obj}{MbecData object}

\item{model.vars}{two covariates of interest to select by first variable
selects color (batch) and second one determines shape (group).}

\item{pca.axes}{numeric vector which axes to plot, first is X and second is Y}

\item{type}{Which abundance matrix to use for the calculation.}

\item{label}{Which corrected abundance matrix to use for analysis.}

\item{return.data}{logical if TRUE returns the data.frame required for
plotting. Default (FALSE) will return plot object.}
}
\value{
either a ggplot2 object or a formatted data-frame to plot from
}
\description{
Takes two covariates, i.e., group and batch, and computes the ordination-plot
for user-selected principal components. Covariates determine sample-shape and
color and can be switched to shift the emphasis on either group. In addition
to the ordination-plot, the function will show the distribution of
eigenvalues (colored by the second covariate) on their respective principal
components.
}
\details{
The function returns either a plot-frame or the finished ggplot object. Input
is an MbecData-object. If cumulative log-ratio (clr) and total sum-scaled
(tss) abundance matrices are part of the input, i.e., 'mbecTransform()' was
used, they can be selected as input by using the 'type' argument with either
"otu", "clr" or "tss". If batch effect corrected matrices are available, they
can be used by specifying the 'type' argument as "cor" and using the 'label'
argument to select the appropriate matrix by its denominator, e.g., for batch
correction method ComBat this would be "bat", for RemoveBatchEffects from the
limma package this is "rbe". Default correction method-labels are "ruv3",
"bmc","bat","rbe","pn","svd".

The combination of 'type' and 'label' argument basically accesses the
attribute 'cor', a list that stores all matrices of corrected counts.
This list can also be accessed via getter and setter methods. Hence, the user
can supply their own matrices with own names.
}
\examples{
# This will return the data.frame for plotting.
data(dummy.mbec)
data.PCA <- mbecPCA(input.obj=dummy.mbec,
model.vars=c('group','batch'), pca.axes=c(1,2), return.data=TRUE)

# This will return the ggplot2 object for display, saving and modification.
# Selected PCs are PC3 on x-axis and PC2 on y-axis.
plot.PCA <- mbecPCA(input.obj=dummy.mbec,
model.vars=c('group','batch'), pca.axes=c(3,2), return.data=FALSE)
}
\keyword{PCA}
\keyword{analysis}
\keyword{component}
\keyword{principal}
