% Generated by roxygen2 (4.0.1): do not edit by hand
\name{testQuantiles}
\alias{testQuantiles}
\title{Function to test quantile equality for theoretical and observed distributions}
\usage{
testQuantiles(theoreticalCumDist, observedCumDist, numTotalCounts,
  numSEsToCheck, errorMessage)
}
\arguments{
\item{theoreticalCumDist}{for (unspecified) value of x, P(X<=x)}

\item{observedCumDist}{for (unspecified) value of x, observed Fraction(values<=x) = Num(values<=x)/Num(total values). Actual values of x must be the same as those for corresponding entries in theoreticalCumDist}

\item{numTotalCounts}{Num(total values) (see argument observedCumDist)}

\item{numSEsToCheck}{number of standard errors to go in each direction from theoretical quantity to see if the estimate falls into the confidence interval}

\item{errorMessage}{error message to return if observed fraction falls outside of confidence interval}
}
\value{
TRUE (all tests were passed, otherwise exits with error message).
}
\description{
Function to test quantile equality for theoretical and observed distributions
}
\details{
For some random variable X, observed sample x1, x2, .., xN, and attainable value x, we compare theoretical P(X<=x) to observed Num(xi <= x)/N.
}
\seealso{
Other unitTestsFunctions: \code{\link{testNumericDiff}}
}

