% Generated by roxygen2 (4.0.1): do not edit by hand
\name{MBASEDMetaAnalysisGetMeansAndSEs}
\alias{MBASEDMetaAnalysisGetMeansAndSEs}
\title{Helper function to obtain estimate of underlying mean and the standard error of the estimate in meta analysis framework.}
\usage{
MBASEDMetaAnalysisGetMeansAndSEs(zValuesMat, zVariancesMat, checkArgs = FALSE)
}
\arguments{
\item{zValuesMat}{matrix of z-values, on standard normal scale. Each row represents a specific genomic locus, while each column represents a set of observed values across loci (in practice, multiple columns represent different outcomes of simulations).}

\item{zVariancesMat}{matrix of (estimated) variances of each z-value in zValuesMat. The interpretation of rows and columns is the same as for zValuesMat.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a list with 4 elements:
\item{weightsMat}{a matrix of same dimension as zValuesMat, giving the assigned weight for each observation}
\item{totalWeights}{a vector of length equal to number of rows in zValuesMat, giving the column sum of assigned weights}
\item{hetQ}{a vector of length equal to number of rows in zValuesMat, giving the estimated standard error for the corresponding entries in meanValues}
\item{meanValues}{a vector of length equal to number of rows in zValuesMat, giving for each column the estimated average value.}
\item{hetQ}{a vector of length equal to number of rows in zValuesMat, giving the estimated standard error for the corresponding entries in meanValues}
}
\description{
Helper function to obtain estimate of underlying mean and the standard error of the estimate in meta analysis framework.
}
\details{
MBASEDMetaAnalysisGetMeansAndSEs is a helper function employed by MBASEDMetaAnalysis(). For each column of input matrices, it calculates the inverse-variance weighted column average and provides an estimate of the standard error of this mean estimator. Input matrices zValuesMat and zVariancesMat have one column for each set of loci ('independent studies') to be combined, with each row corresponding to an individual locus.
}
\examples{
set.seed(127000)
zVals1=rnorm(5, mean=rep(2,5), sd=sqrt(1:5))
zVals2=rnorm(5, mean=0, sd=1)+c(0,0,5,0,0) ## one outlier
MBASED:::MBASEDMetaAnalysisGetMeansAndSEs(zValuesMat=matrix(c(zVals1, zVals2), ncol=2), zVariancesMat=matrix(c(1:5, rep(1,5)), ncol=2))
}

