% Generated by roxygen2 (4.0.1): do not edit by hand
\name{MBASEDMetaAnalysis}
\alias{MBASEDMetaAnalysis}
\title{Generic function to perform standard meta analysis.}
\usage{
MBASEDMetaAnalysis(zValuesMat, zVariancesMat, alternative = "two.sided",
  checkArgs = FALSE)
}
\arguments{
\item{zValuesMat}{matrix of z-values, on standard normal scale. Each row represents a specific genomic locus, while each column represents a set of observed values across loci (in practice, multiple columns represent different outcomes of simulations).}

\item{zVariancesMat}{matrix of (estimated) variances of each z-value in zValuesMat. The interpretation of rows and columns is the same as for zValuesMat.}

\item{alternative}{one of 'two.sided', 'greater', 'less'. DEFAULT: 'two.sided'.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a list with 5 elements:
\item{hetPVal}{a 1-row marix of heterogeneity p-values.}
\item{hetQ}{a 1-row matrix of heterogeneity statistics.}
\item{fixedEffectsMeans}{a 1-row matrix of column-specific fixed-effects meta analysis restults.}
\item{fixedEffectsSEs}{a 1-row matrix of estimated SEs of fixed-effects meta analysis results.}
\item{pvalueFixed}{a 1-row matrix of p-values for fixed-effects analysis.}
}
\description{
Generic function to perform standard meta analysis.
}
\details{
MBASEDMetaAnalysis performs meta analysis calculations in a vectorized fashion. Input matrices zValuesMat and zVariancesMat have one column for each set of loci ('independent studies') to be combined, with each row corresponding to an individual locus. MBASEDMetaAnalysis uses meta analysis approach to combine values in each column of zValuesMat into a single column-specific value of z (using corresponding supplied variances to appropriately weight contributions of each individual z). The function reports the resulting averaged z values, together with corresponding standard deviations (standard errors), for fixed-effects setting (note: random effects are not meaningful in the context of SNVs in ASE). If the supplied matrices have a single row (only one locus), no meta-analysis is possible, and the original value and corresponding standard deviations are returned.
}
\examples{
set.seed(127000)
zVals1=rnorm(5, mean=rep(2,5), sd=sqrt(1:5))
zVals2=rnorm(5, mean=0, sd=1)+c(0,0,5,0,0) ## one outlier
MBASED:::MBASEDMetaAnalysis(zValuesMat=matrix(c(zVals1, zVals2), ncol=2), zVariancesMat=matrix(c(1:5, rep(1,5)), ncol=2), alternative='two.sided')
}

