% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebayes-helpers.R
\name{ebayes}
\alias{ebayes}
\title{Estimate hyperparameters for hierarchical variance model for continuous component}
\usage{
ebayes(assay_t, ebayesControl, mm, truncate = Inf)
}
\arguments{
\item{assay_t}{cells X genes matrix}

\item{ebayesControl}{list with (optional) components 'method', 'model'.  See details.}

\item{mm}{a model matrix, used when \code{model='H1'}.}

\item{truncate}{Genes with sample precisions exceeding this value are discarded when estimating the hyper parameters}
}
\value{
\code{numeric} of length two, giving the hyperparameters in terms of a variance (\code{v}) and prior observations (\code{df}), inside a \code{structure}, with component \code{hess}, giving the Fisher Information of the hyperparameters.
}
\description{
\code{ebayesControl} is a named list with (optional) components 'method' (one of 'MOM' or 'MLE') and 'model' (one of 'H0' or 'H1')
method MOM uses a method-of-moments estimator, while MLE using the marginal likelihood.
H0 model estimates the precisions using the intercept alone in each gene, while H1 fits the full model specified by \code{mm}
}
