% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZlmFit-bootstrap.R
\name{pbootVcov1}
\alias{pbootVcov1}
\alias{bootVcov1}
\title{Bootstrap a zlmfit}
\usage{
pbootVcov1(cl, zlmfit, R = 99)

bootVcov1(zlmfit, R = 99, boot_index = NULL)
}
\arguments{
\item{cl}{a \code{cluster} object created by \code{makeCluster}}

\item{zlmfit}{class \code{ZlmFit}}

\item{R}{number of bootstrap replicates}

\item{boot_index}{list of indices to resample.  Only one of R or boot_index can be offered.}
}
\value{
array of bootstrapped coefficients

array of bootstrapped coefficients
}
\description{
Sample cells with replacement to find bootstrapped distribution of coefficients
}
\section{Functions}{
\itemize{
\item \code{pbootVcov1()}: parallel version of bootstrapping

}}
\examples{
data(vbetaFA)
zlmVbeta <- zlm(~ Stim.Condition, subset(vbetaFA, ncells==1)[1:5,])
#Only run 3 boot straps, which you wouldn't ever want to do in practice...
bootVcov1(zlmVbeta, R=3)
}
