% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/lmWrapper-glmer.R
\docType{class}
\name{LMERlike-class}
\alias{LMERlike-class}
\alias{update,LMERlike-method}
\alias{vcov,LMERlike-method}
\alias{coef,LMERlike-method}
\alias{logLik,LMERlike-method}
\title{Wrapper for lmer/glmer}
\usage{
\S4method{update}{LMERlike}(object, formula., design, keepDefaultCoef = FALSE, ...)

\S4method{vcov}{LMERlike}(object, which, ...)

\S4method{coef}{LMERlike}(object, which, singular = TRUE, ...)

\S4method{logLik}{LMERlike}(object)
}
\arguments{
\item{object}{\code{LMERlike}}

\item{formula.}{\code{formula}}

\item{design}{something coercible to a \code{data.frame}}

\item{keepDefaultCoef}{\code{logical}. Should the coefficient names be preserved from \code{object} or updated if the model matrix has changed?}

\item{...}{In the case of \code{vcov}, ignored.  In the case of \code{update}, passed to \code{model.matrix}.}

\item{which}{\code{character}, one of 'C', 'D'.}

\item{singular}{\code{logical}. Should NA coefficients be returned?}
}
\value{
see the section "Methods (by generic)"
}
\description{
A horrendous hack is employed in order to do arbitrary likelihood ratio tests: the model matrix is built, the names possibly mangled, then fed in as a symbolic formula to glmer/lmer.
This is necessary because there is no (easy) way to specify an arbitrary fixed-effect model matrix in glmer.
}
\section{Methods (by generic)}{
\itemize{
\item \code{update(LMERlike)}: update the formula or design matrix

\item \code{vcov(LMERlike)}: return the variance/covariance of component \code{which}

\item \code{coef(LMERlike)}: return the coefficients.  The horrendous hack is attempted to be undone.

\item \code{logLik(LMERlike)}: return the log-likelihood

}}
\section{Slots}{

\describe{
\item{\code{pseudoMM}}{part of this horrendous hack.}

\item{\code{strictConvergence}}{\code{logical} (default: \code{TRUE}) return results even when the optimizer or *lmer complains about convergence}

\item{\code{optimMsg}}{\code{character} record warnings from lme.  \code{NA_character_} means no warnings.}
}}

