## Documentation of data objects

#' Subset of the single-cell murine lung data at steady state from an MPC experiment
#' @docType data
#' @format a matrix containing cells from 266 wells (50 cells/well)
#' @source \url{https://flowrepository.org/id/FR-FCM-Z2LP}
#' @usage data(ord.fcs.raw.mt_ffc)
"ord.fcs.raw.mt_ffc"

#' Metadata of the example MPC data
#' @docType data
#' @format a data.frame
#' @usage data(ord.fcs.raw.meta.df.out_ffc)
"ord.fcs.raw.meta.df.out_ffc"

#' Subset of the sorted CD4+ and CD8+ T cells from mice splenocytes from an FFC experiment
#' @docType data
#' @format a matrix containing cells from 5 batches (50 cells/batch)
#' @source \url{http://flowrepository.org/id/FR-FCM-Z6UG}
#' @usage data(ord.fcs.raw.mt_mpc) 
"ord.fcs.raw.mt_mpc"

#' Metadata of the example FFC data
#' @docType data
#' @format a data.frame
#' @usage data(ord.fcs.raw.meta.df.out_mpc) 
"ord.fcs.raw.meta.df.out_mpc"
