% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{qtlVennPlot}
\alias{qtlVennPlot}
\title{qtlVennPlot}
\usage{
qtlVennPlot(
  meth.qtl.result.list,
  out.folder,
  type = "SNP",
  out.name = NULL,
  ...
)
}
\arguments{
\item{meth.qtl.result.list}{A named list with each entry being an object of type \code{\link{MethQTLResult-class}}.
The names are used in the visualization.}

\item{out.folder}{Required argument specifying the location to store the resulting plot}

\item{type}{Determines if either the SNP (default), the CpG, or the correlation block
\code{'cor.block'} is to be visualized}

\item{out.name}{Optional argument for the name of the plot on disk (ending needs to be .png)}

\item{...}{Further argument passed to \code{\link[VennDiagram]{venn.diagram}}}
}
\value{
None
}
\description{
This function creates a venn plot from a list of methQTL results, showing the overlap between the interactions
}
\details{
The plot can be stored on disk using \code{out.folder} and \code{out.name}
}
\examples{
meth.qtl.res.1 <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
meth.qtl.res.2 <- meth.qtl.res.1
qtlVennPlot(list(A=meth.qtl.res.1,B=meth.qtl.res.2),out.folder=getwd())
}
\author{
Michael Scherer
}
