% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_import.R
\name{doImport}
\alias{doImport}
\title{doImport}
\usage{
doImport(
  data.location,
  s.anno = NULL,
  assembly.meth = "hg19",
  assembly.geno = "hg19",
  tab.sep = ",",
  s.id.col = "sample_id",
  out.folder = tempdir(),
  ...
)
}
\arguments{
\item{data.location}{Named character vector specifying the data location. The names correspond to:
\describe{
\item{idat.dir}{Path to the DNA methylation data. Can be in the form of IDAT files or in any other
   format accepted by RnBeads}
\item{geno.dir}{Path to the genotyping data file directory, either containing PLINK files
(i.e. with \code{bed}, \code{bim} and \code{fam} files), imputed, (dosage) files (i.e. with
 \code{dos} and \code{txt} files), or \code{idat} files}
}}

\item{s.anno}{Path to the sample annotation sheet. If \code{NULL}, the program searches for potential sample
annotation sheets in the data location directories.}

\item{assembly.meth}{Assembly used for the DNA methylation data. Typically is \code{"hg19"} for Illumina BeadArray
data.}

\item{assembly.geno}{Assembly used for the genotyping data. If it is not the same as \code{assembly.geno}, the
positions will be matched using liftOver.}

\item{tab.sep}{The table separator used for the sample annotation sheet.}

\item{s.id.col}{The column name of the sample annotation sheet that specifies the sample identifier.}

\item{out.folder}{The output directory to store diagnostic plots}

\item{...}{Futher parameters passed to e.g. \code{doGenoImport}}
}
\value{
An object of type \code{\link{MethQTLInput-class}} with the methylation and genotyping information added.
}
\description{
Performs input for the given DNA methylation and genotyping data.
}
\details{
Import of DNA methylation and genotyping data is done separately:
       \describe{
       \item{DNA methylation data}{DNA methylation data is imported using the \code{\link{RnBeads}} package. We
       use a default option setting commonly used for DNA methylation data obtained from the Illumina BeadArray
       series. If you want to specify further options, we refer to the \code{\link{rnb.options}}.}
       \item{Genotyping data}{Genotyping data is processed using PLINK. We focus on genotyping data generated
       with the Illumina BeadArray series and use default options. For further option settings, you should consult
       the \code{\link{qtlSetOption}} documentation.}
       }

   You can specify the import type using \code{\link{qtlSetOption}} through the options
       \code{meth.data.type} and \code{geno.data.type}.

       This function internally uses \code{doMethImport} and \code{doGenoImport}
}
\examples{
 meth.qtl.in <- loadMethQTLInput(system.file("extdata","reduced_methQTL",package="MAGAR"))
 meth.qtl.in
}
\author{
Michael Scherer
}
