% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdgopt.R
\name{bdgopt}
\alias{bdgopt}
\title{bdgopt}
\usage{
bdgopt(
  ifile,
  method = c("multiply", "add", "p2q", "max", "min"),
  extraparam = numeric(),
  outputfile = character(),
  outdir = ".",
  log = TRUE,
  verbose = 2L
)
}
\arguments{
\item{ifile}{MACS score in bedGraph. Note: this must be a bedGraph
file covering the ENTIRE genome. REQUIRED}

\item{method}{Method to modify the score column of bedGraph file. Available choices are: multiply, add, max, min, or p2q. 1) multiply, the EXTRAPARAM is required and will be multiplied to the score column. If you intend to divide the score column by X, use value of 1/X as EXTRAPARAM. 2) add, the EXTRAPARAM is required and will be added to the score column. If you intend to subtract the score column by X, use value of -X as EXTRAPARAM. 3) max, the EXTRAPARAM is required and will take the maximum value between score and the EXTRAPARAM. 4) min, the EXTRAPARAM is required and will take the minimum value between score and the EXTRAPARAM. 5) p2q, this will convert p-value scores to q-value scores using Benjamini-Hochberg process. The EXTRAPARAM is not required. This method assumes the scores are -log10 p-value from MACS3. Any other types of score will cause unexpected errors. Default="p2q"}

\item{extraparam}{The extra parameter for METHOD. Check the detail
of -m option.}

\item{outputfile}{Output BEDGraph filename. Required.}

\item{outdir}{The output directory.}

\item{log}{Whether to capture logs.}

\item{verbose}{Set verbose level of runtime message. 0: only show
critical message, 1: show additional warning message, 2: show
process information, 3: show debug messages. DEFAULT:2}
}
\value{
\code{macsList} object.
}
\description{
Operations on score column of bedGraph file. Note: All regions on
the same chromosome in the bedGraph file should be continuous so
only bedGraph files from MACS3 are accpetable.
}
\examples{
eh <- ExperimentHub::ExperimentHub()
CHIP <- eh[["EH4558"]]
CTRL <- eh[["EH4563"]]
c1 <- callpeak(CHIP, CTRL, gsize = 5.2e7, cutoff_analysis = TRUE,
               outdir = tempdir(), name = "callpeak_narrow0",
               store_bdg = TRUE)
cfile <- grep("treat_pileup.bdg", c1$outputs, value = TRUE)
bdgopt(cfile, method = "min", extraparam = 10,
       outdir = tempdir(), outputfile = "bdgopt_min.bdg")
}
