% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/on_plate_selection.r
\name{on_plate_selection}
\alias{on_plate_selection}
\title{Sort experimental design on graphical 96-well-plate}
\usage{
on_plate_selection(MACSQuant,number_of_replicates,number_of_conditions,
control=FALSE,save.files=FALSE)
}
\arguments{
\item{MACSQuant}{object of class MACSQuant resulting of the function
load_maxQuant().
Contains the original data table}

\item{number_of_replicates}{For each condition, the number of duplicates
(must be the same for all conditions)}

\item{number_of_conditions}{The number of conditions tested
(eg: Drug 1 alone, Drug 2 alone)}

\item{control}{Is there a control in this experiment (eg: Staurosporin)}

\item{save.files}{Used to save the image in the output folder}
}
\value{
A formatted report file along with intermediates results
}
\description{
Loads user's data, prompt a graphical representation of a 96
well plate and let the user select where the duplicates of each
condition were placed. Use for reordering excel file.
Plate image with selection can also be saved in the form of a png
file in the "specified_path/output_MQ" directory.
}
\examples{
print("run manually, requires user input")
# on_plate_selection(MACSQuant,3,5)
# let you select 5 conditions of 3 replicates each
}
